<?php
/* --------------------------------------------------------------
  ReaderDatabase.php 2020-02-24
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan\Repository\Reader;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\FetchMode;

/**
 * Class ReaderDatabase
 * @package Gambio\Shop\Attributes\SellingUnitEan\Repository\Reader
 */
class ReaderDatabase implements ReaderInterface
{
    protected const PRODUCTS_ATTRIBUTES_TABLE_NAME                           = "products_attributes";
    protected const PRODUCTS_ATTRIBUTES_OPTION_VALUE_TABLE_COLUMN_IDENTIFIER = "options_values_id";
    protected const PRODUCTS_ATTRIBUTES_PRODUCT_TABLE_COLUMN_IDENTIFIER      = "products_id";
    protected const PRODUCTS_ATTRIBUTES_EAN_TABLE_COLUMN_VALUE               = "gm_ean";
    
    
    /**
     * @var Connection
     */
    protected $connection;
    
    
    /**
     * ReaderDatabase constructor.
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getEanValuesByProductId(array $optionIds, int $productId) : array
    {
        if(empty($optionIds)) {
            return [];
        }
        $q    = $this->connection->createQueryBuilder();
        $data = $q->select(self::PRODUCTS_ATTRIBUTES_EAN_TABLE_COLUMN_VALUE)->from(
            self::PRODUCTS_ATTRIBUTES_TABLE_NAME
        )->where(
            $q->expr()->in(self::PRODUCTS_ATTRIBUTES_OPTION_VALUE_TABLE_COLUMN_IDENTIFIER, $optionIds)
        )->andWhere(
            self::PRODUCTS_ATTRIBUTES_PRODUCT_TABLE_COLUMN_IDENTIFIER . ' = :product_id'
        )->setParameter(
            'product_id',
            $productId
        )->execute();
        
        return $data->fetchAll(FetchMode::COLUMN);
    }
}